/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <dos.h>
#include <malloc.h>
#include <math.h>
#include <string.h>

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define TIMER_18		65535

#define TIMER_1000	1193

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static volatile long int
	clock_ticks;

static void
	( __interrupt __far * previous_timer_routine ) ();

static int
	processor_speed,
	video_speed;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#define SCREEN_WIDTH		320
#define SCREEN_HEIGHT	200

#define SCREEN_SIZE		( ( unsigned int ) ( SCREEN_WIDTH * SCREEN_HEIGHT ) )

static char
	* work_screen,
	* video_screen;

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

static void __interrupt __far timer_routine ( void );

static void set_timer_rate ( unsigned int rate );

static void install_timer ( void );

static void deinstall_timer ( void );

static void set_graphics_mode ( void );

static void set_text_mode ( void );

static unsigned int isqrt ( unsigned int n );

static void processor_speed_test ( void );

static void video_speed_test ( void );

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void main ( void )
{
	set_graphics_mode ();

	install_timer ();

	processor_speed_test ();

	video_speed_test ();

	deinstall_timer ();

	set_text_mode ();

	write_results_file ();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void __interrupt __far timer_routine ( void )
{
	clock_ticks ++;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void set_timer_rate ( unsigned int rate )
{
	_disable ();

	outp ( 0x43, 0x36 );

	outp ( 0x40, rate % 256 );

	outp ( 0x40, rate / 256 );

	_enable ();
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void install_timer ( void )
{
	previous_timer_routine = _dos_getvect ( 0x1C );

	_dos_setvect ( 0x1C, timer_routine );

	set_timer_rate ( TIMER_1000 );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void deinstall_timer ( void )
{
	set_timer_rate ( TIMER_18 );

	_dos_setvect ( 0x1C, previous_timer_routine );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void set_graphics_mode ( void )
{
	union REGS
		regs;

	regs . w . ax = 0x0013;

	int386 ( 0x10, & regs, & regs );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void set_text_mode ( void )
{
	union REGS
		regs;

	regs . w . ax = 0x0003;

	int386 ( 0x10, & regs, & regs );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

unsigned int isqrt ( unsigned int n )
{
	unsigned int
		mask,
		approx,
		root,
		test;

	if ( n )
	{
		mask = 0xC0000000;
		approx = 0x8000;

		while ( ! ( n & mask ) )
		{
			mask >>= 2;
			approx >>= 1;
		}

		root = approx;

		while ( approx >>= 1 )
		{
			root += approx;

			test = root * root;

			if ( test == n )
			{
				return ( root );
			}
			else if ( test > n )
			{
				root -= approx;
			}
		}

		return ( root );
	}
	else
	{
		return ( 0 );
	}
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void processor_speed_test ( void )
{
	int
		loop;

	unsigned int
		x;

	clock_ticks = 0;

	x = 0;

	for ( loop = 0; loop < 100000; loop ++ )
	{
		isqrt ( x );

		x += 0xFFFFFFFF / 100000;
	}

	processor_speed = clock_ticks;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void video_speed_test ( void )
{
	int
		loop;

	work_screen = malloc ( SCREEN_SIZE );

	video_screen = ( char * ) 0xA0000;

	memset ( work_screen, 0, SCREEN_SIZE );

	clock_ticks = 0;

	for ( loop = 0; loop < 256; loop ++ )
	{
		memcpy ( video_screen, work_screen, SCREEN_SIZE );
	}

	video_speed = clock_ticks;
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void write_results_file ( void )
{
	FILE
		* fp;

	int
		speed_index;

	fp = fopen ( "vidspeed.txt", "w" );

	if ( fp != NULL )
	{
//		fprintf ( fp, "Ŀ\n" );
//		fprintf ( fp, " VIDSPEED RESULTS \n" );
//		fprintf ( fp, "\n" );
//		fprintf ( fp, "\n" );
//		fprintf ( fp, "Processor speed is %.3g times slower than a 100Mhz Pentium.\n", processor_speed / 371.0 );
//		fprintf ( fp, "\n" );
//		fprintf ( fp, "Video speed is %.3g times slower than a 100Mhz Pentium.\n", video_speed / 881.0 );

		
		speed_index = 9 - ((int) ((processor_speed + video_speed) / 1000.0));

		fprintf ( fp, "Visual Detail=%d", speed_index);
	}

	fclose ( fp );
}

/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

