/////////////////////////////////////////////////////////////////////////////
// GV.H                                                                    //
//                                                                         //
// GameVision(tm) Game Toolkit for Watcom C/C++ 10.x                       //
// Copyright (c) 1994-96 Jarrod Davis Software Co.                         //
// All rights reserved.                                                    //
/////////////////////////////////////////////////////////////////////////////

#ifndef gv_h
#define gv_h

// INCLUDES /////////////////////////////////////////////////////////////////
#include <stdlib.h>
#include <malloc.h>
#include <stdio.h>
#include <conio.h>
#include <i86.h>
#include <mem.h>
#include <math.h>
#include <dos.h>
#include <io.h>
#include <limits.h>
#include <time.h>

// DEFINES //////////////////////////////////////////////////////////////////
// Misc
#define FALSE       0
#define TRUE        1
#define BUFFSIZE 4096

// Keyboard
#define KEY_SPACE  0x39
#define KEY_ENTER  0x1C
#define KEY_LEFT   0x4B
#define KEY_RIGHT  0x4D
#define KEY_ESC    0x01
#define KEY_CTRL   0x1D
#define KEY_UP     0x48
#define KEY_DOWN   0x50
#define KEY_ALT    0x38
#define KEY_F1     0x3B
#define KEY_F2     0x3C
#define KEY_F3     0x3D
#define KEY_F4     0x3E
#define KEY_F5     0x3F
#define KEY_F6     0x40
#define KEY_F7     0x41
#define KEY_F8     0x42
#define KEY_F9     0x43
#define KEY_F10    0x44
#define KEY_TAB    0x0F
#define KEY_N      0x31
#define KEY_Y      0x15
#define KEY_END    79
#define KEY_RSHIFT 0x36
#define KEY_LSHIFT 0x2A

// Application Events
#define APP_INIT       0
#define APP_RUN        1
#define APP_PAUSE      3
#define APP_DONE       4

// Command Ids
#define CMD_NONE       0x0000
#define CMD_MOVEUP     0x0001
#define CMD_MOVEDOWN   0x0002
#define CMD_MOVELEFT   0x0004
#define CMD_MOVERIGHT  0x0008
#define CMD_QUIT       0x0010
#define CMD_FIRE1      0x0020
#define CMD_FIRE2      0x0040
#define CMD_FIRE3      0x0080
#define CMD_SELECT     0x0100

// Video
#define PAGE_WIDTH  320
#define PAGE_HEIGHT 200
#define PAGE_SIZE   64000

// Stack
#define STACK_INITSIZE 8

// Library
#define LIB_MAX 256

// Math
#define PI 3.1415926535897932385

// Polygon
#define VERTICES_MAX 16

// Fade Messages
#define MSG_FADE_IN  1
#define MSG_FADE_OUT 2

// TYPEDEFS /////////////////////////////////////////////////////////////////
// Misc
typedef int BOOL;
typedef FILE *PFILE;

// Fundamental types
typedef char  *PCHAR;
typedef void  *PVOID;
typedef short *SHORT;
typedef int   *PINT;
typedef unsigned char  UCHAR,  *PUCHAR;
typedef unsigned short USHORT, *PUSHORT;
typedef unsigned int   UINT,   *PUINT;
typedef unsigned long  ULONG,  *PULONG;

// STRUCTURES ///////////////////////////////////////////////////////////////

// TCOLOR
typedef struct {
  UCHAR red;
  UCHAR green;
  UCHAR blue;
} TCOLOR;

// TPALETTE
typedef struct TPALETTE {
  TCOLOR color[256];
}*PPALETTE;

// TTRANSLATETABLE
typedef struct TTRANSLATETABLE {
  UCHAR index[256];
} *PTRANSLATETABLE;

// TSTACK
typedef struct TSTACK {
  UINT  top;
  UINT  size;
  PUINT base;
} *PSTACK;

// TLIBENTRY
typedef struct TLIBENTRY {
  char  filename[13];
  ULONG pos;
  ULONG size;
  BOOL  in_use;
} *PLIBENTRY;

// TLIBRARY
typedef struct TLIBRARY {
  char  id[25];
  FILE *lib_file;
  TLIBENTRY entry[LIB_MAX];
} *PLIBRARY;

// TACTION
typedef void TACTION(void);
typedef TACTION *PACTION;

// TTASK
struct TTASK;
typedef void TASKACTION(TTASK *task);
typedef TASKACTION *PTASKACTION;

typedef void TASKACTIONCOLLIDE(TTASK *task, TTASK *task_hit);
typedef TASKACTIONCOLLIDE *PTASKACTIONCOLLIDE;

typedef BOOL TASKACTIONOVERLAP(TTASK *task1, TTASK *task2);
typedef TASKACTIONOVERLAP *PTASKACTIONOVERLAP;

struct TTASKLIST;
typedef struct TTASK {
  struct      TTASK *prev;
  struct      TTASK *next;
  int         id;
  int         group;
  int         frame;
  int         timer;
  int         hits;
  int         energy;
  int         msg_id;
  PUCHAR      msg_data;
  float       x,y,z;
  float       xs,ys,zs;
  int         width,height;
  BOOL        can_collide;
  BOOL        accept_msg;
  BOOL        active;
  BOOL        kill;
  TTASKLIST   *list;
  PTASKACTION Process;
  PTASKACTION Done;
  PTASKACTIONCOLLIDE OnCollide;
  PTASKACTIONOVERLAP Overlap;
  PTASKACTION OnMessage;
} *PTASK;

typedef struct TTASKLIST {
  PTASK head;
  PTASK tail;
  int   size;
} *PTASKLIST;

// TBITMAP
typedef struct TBITMAP {

  int    width;
  int    height;
  PUCHAR data;
} *PBITMAP;

// TSPRITE
typedef struct TSPRITE {
  PBITMAP bitmaps;
  int     frames;
  int     max_width;
  int     max_height;
} *PSPRITE;

typedef struct TEVENT {
  UINT     kind;
  UINT     cmd;
  int      x1,y1,x2,y2;
  PSPRITE  system_fnt;
  PUCHAR   page;
} *PEVENT;

// TFADEPALETTE
typedef struct TFADEPALETTE {
  TPALETTE pal;
  TPALETTE cur_pal;
  int      index;
  int      first;
  int      count;
  int      level;
  int      fade_delay;
  int      fade_timer;
} *PFADEPALETTE;

// TMESSAGE
typedef struct TMESSAGE {
  int    id;
  PUCHAR data;
} *PMESSAGE;

// TVERTEX
typedef struct TVERTEX {
  float x, y;
} *PVERTEX;

// TPOLYGON
typedef struct TPOLYGON {
  int     b_color;
  int     i_color;
  BOOL    closed;
  BOOL    filled;
  int     num_vertices;
  TVERTEX vertices[VERTICES_MAX];
} *PPOLYGON;

/////////////////////////////////////////////////////////////////////////////
// PRE-BUILDIT TASK LIBRARY                                                //
/////////////////////////////////////////////////////////////////////////////

// TFADE
typedef struct TFADE: TTASK {
  int          type;
  int          level;
  int          fade_delay;
  TFADEPALETTE pal;
} *PFADE;

// GLOBALS //////////////////////////////////////////////////////////////////

extern UCHAR temp_byte;
extern UCHAR buff[BUFFSIZE];
extern long  rand_seed;
extern UINT  cmd;

// Tables
extern float SIN_TABLE[361];
extern float COS_TABLE[361];

// Registers
extern struct SREGS sregs;
extern union  REGS  regs;

// Keyboard
extern BOOL  kbd_handler_installed;
extern int   GV_Key[128];
extern int   GV_Asc[128];
extern int   ShiftNames[];
extern int   key_scancode;
extern int   key_code;

// Video Page
extern PUCHAR mpage;
extern PUCHAR vpage;
extern PUCHAR hpage;
extern int minx;
extern int miny;
extern int maxx;
extern int maxy;
extern int view_width;
extern int view_height;
extern int view_width_center;
extern int view_height_center;
extern int cursorx;
extern int cursory;
extern int char_width;

// Palettes
extern const TPALETTE default_pal;
extern TPALETTE black_pal;
extern TPALETTE white_pal;
extern TPALETTE cur_pal;

// Task Lists
extern TTASKLIST starlist;
extern TTASKLIST enemylist;
extern TTASKLIST herolist;
extern TTASKLIST msglist;
extern TTASKLIST systemlist;

// Misc
extern BOOL    game_over;
extern BOOL    game_quit;
extern BOOL    game_levelover;
extern int     game_level;
extern int     game_score;
extern PSPRITE system_fnt;

// MISC. ROUTINES ///////////////////////////////////////////////////////////
void DoNothing(PTASK task);

// TABLE ROUTINES //////////////////////////////////////////////////////////
void GV_TablesInit(void);

// RANDOM NUMBER ROUTINES ///////////////////////////////////////////////////
void GV_Randomize(void);

long GV_Rand(long min, long max);

// KEYBOARD ROUTINES ////////////////////////////////////////////////////////
void GV_kbdInit(BOOL activate);

BOOL GV_kbdDown(UCHAR key);

void GV_kbdWait(void);

BOOL GV_kbdHit(void);

int GV_kbdAsc(void);

void GV_kbdClear(void);

void GV_kbdOn(void);

void GV_kbdOff(void);

// TEXT MODE ROUTINES ///////////////////////////////////////////////////////
void GV_TextPrint(PCHAR text, int color, int x, int y);
void GV_TextCenter(PCHAR text, int color, int y);

// MODE ROUTINES ////////////////////////////////////////////////////////////
void GV_ModeSet(int mode);
void GV_ModeGraph();
void GV_ModeText();

// VIEWPORT ROUTINES ////////////////////////////////////////////////////////
void GV_ViewPortSet(int X1, int Y1, int X2, int Y2);

void GV_ViewPortClear(PUCHAR page, int color);

void GV_ViewPortSetCursor(int x, int y);

void GV_ViewPortShow(PUCHAR page);

void GV_ViewPortScrollUp(PUCHAR page, int num, int bkcolor);

void GV_ViewPortPrint(PSPRITE font, PCHAR string, int color, int space,
  BOOL transparent, BOOL fixed_space, PUCHAR page, int bkcolor, BOOL new_line);

void GV_ViewPortNextLine(PSPRITE font, PUCHAR page, int bkcolor);

// PAGE ROUTINES ////////////////////////////////////////////////////////////
PUCHAR GV_PageNew(void);

void GV_PageFree(PUCHAR page);

void GV_PageFill(PUCHAR page, UCHAR color);

void GV_PageShow(PUCHAR page);

void GV_RectFill(int x1, int y1, int x2, int y2, PUCHAR page, UCHAR color);

void GV_RectCopy(int x1, int y1, int x2, int y2, PUCHAR spage, PUCHAR dpage);

void GV_RectCopyTo(int x1, int y1, int x2, int y2, int dx1, int dy1,
  PUCHAR spage, PUCHAR dpage);

void GV_PageCopy(PUCHAR spage, PUCHAR dpage);

// PALETTE ROUTINES /////////////////////////////////////////////////////////
void GV_PaletteSet(PPALETTE palette);

void GV_PaletteGet(PPALETTE palette);

void GV_PaletteSetRange(PPALETTE palette, int first, int count);

void GV_PaletteGetRange(PPALETTE palette, int first, int count);

BOOL GV_PaletteLoad(PPALETTE palette, PCHAR filename);

void GV_PaletteTrans(PTRANSLATETABLE table, PPALETTE palette, float percent);

void GV_PaletteTransRemap(PTRANSLATETABLE table, PPALETTE cpal, PPALETTE spal,
  float percent);

void GV_PaletteFadeIn(PPALETTE pal, int level, int fade_delay);

void GV_PaletteFadeOut(PPALETTE pal, int level, int fade_delay);

// PIXEL ROUTINES ///////////////////////////////////////////////////////////
void GV_PixelSet(int color, int x, int y, PUCHAR page);

// BITMAP ROUTINES //////////////////////////////////////////////////////////
void GV_BitmapGet(PUCHAR bitmap, UINT width, UINT height, int x, int y,
  PUCHAR page);

void GV_BitmapTrans(PUCHAR bitmap, int width, int height,
  BOOL transparent, PTRANSLATETABLE table);

void GV_BitmapDraw(PUCHAR bitmap, int width, int height, int x, int y,
  BOOL transparent, PUCHAR page);

void GV_BitmapScale(PUCHAR bitmap, int width, int height, int min_x,
  int min_y, int max_x, int max_y, int scale_x, int scale_y, int x1, int y1,
  int x2, int y2, BOOL transparent, PUCHAR page);

void GV_BitmapScaleColor(PUCHAR bitmap, int width, int height, int color,
  int min_x, int min_y, int max_x, int max_y, int scale_x, int scale_y,
  int x1, int y1, int x2, int y2, BOOL transparent, PUCHAR page);

void GV_BitmapScaleTrans(PUCHAR bitmap, int width, int height, int min_x,
  int min_y, int max_x, int max_y, int scale_x, int scale_y, int x1, int y1,
  int x2, int y2,  BOOL transparent, PUCHAR page, PTRANSLATETABLE table);

void GV_BitmapScaleShadow(PUCHAR bitmap, int width, int height, int min_x,
  int min_y, int max_x, int max_y, int scale_x, int scale_y, int x1, int y1,
  int x2, int y2,  BOOL transparent, PUCHAR page, PTRANSLATETABLE table);

// SPRITE ROUTINES //////////////////////////////////////////////////////////
BOOL GV_SpriteLoad(PSPRITE sprite, const PCHAR filename, PPALETTE palette);

BOOL GV_SpriteLib(PLIBRARY lib, PSPRITE sprite, const PCHAR filename,
  PPALETTE palette);

void GV_SpritePaletteTransRemap(PSPRITE sprite, BOOL transparent,
  PPALETTE cpal, PPALETTE spal,  float factor);

BOOL GV_SpriteSave(PSPRITE sprite, PPALETTE pal, const PCHAR filename);

void GV_SpriteFree(PSPRITE sprite);

int GV_SpriteWidth(PSPRITE sprite, int frame);

int GV_SpriteHeight(PSPRITE sprite, int frame);

void GV_SpriteNextFrame(PSPRITE sprite, int *frame, int *width, int *height,
  int frame_inc);

void GV_SpriteDraw(PSPRITE sprite, int frame, int x, int y, BOOL transparent,
  PUCHAR page);

void GV_SpriteDrawClip(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page, int x1, int y1, int x2, int y2);

void GV_SpriteDrawTransClip(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page, PTRANSLATETABLE table, int x1, int y1,
  int x2, int y2);

void GV_SpriteDrawColor(PSPRITE sprite, int frame, int color, int x, int y,
  BOOL transparent, PUCHAR page);

void GV_SpriteDrawColorClip(PSPRITE sprite, int frame, int color, int x,
  int y, BOOL transparent, PUCHAR page, int x1, int y1, int x2, int y2);

void GV_SpriteDrawTrans(PSPRITE sprite, int frame, int x, int y, BOOL transparent,
  PUCHAR page, PTRANSLATETABLE table);

void GV_SpriteCenter(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page);

void GV_SpriteCenterClip(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page, int x1, int y1, int x2, int y2);

void GV_SpriteScale(PSPRITE sprite, int frame, int x, int y, BOOL transparent,
  PUCHAR page, float scale);

void GV_SpriteScaleClip(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page, float scale, int x1, int y1, int x2, int y2);

void GV_SpriteScaleCenter(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page, float scale);

void GV_SpriteScaleCenterClip(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page, float scale, int x1, int y1, int x2, int y2);

void GV_SpriteScaleTrans(PSPRITE sprite, int frame, int x, int y, BOOL transparent,
  PUCHAR page, float scale, PTRANSLATETABLE table);

void GV_SpriteDrawShadow(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page, PTRANSLATETABLE table);

void GV_SpriteCenterShadow(PSPRITE sprite, int frame, int x, int y,
  BOOL transparent, PUCHAR page, PTRANSLATETABLE table);

// FONT ROUTINES ////////////////////////////////////////////////////////////
void GV_FontPrint(PSPRITE font, PCHAR string, int color, int space,
  int x, int y, BOOL transparent, BOOL fixed_space, PUCHAR page);

void GV_FontPrintClip(PSPRITE font, PCHAR string, int color, int space,
  int x, int y, BOOL transparent, PUCHAR page, int x1, int y1, int x2, int y2);

int GV_FontLen(PSPRITE font, PCHAR string, int space, BOOL fixed_space);

void GV_FontPrintCenter(PSPRITE font, PCHAR string, int color, int space,
  int y, BOOL transparent, BOOL fixed_space, PUCHAR page);

// PCX Routines /////////////////////////////////////////////////////////////
BOOL GV_PCXLoad(const PCHAR filename, PUCHAR page, PPALETTE palette);

BOOL GV_PCXLib(PLIBRARY lib, const PCHAR filename, PUCHAR page,
  PPALETTE palette);

void GV_PCXMem(PUCHAR buffer, long size, PUCHAR page, PPALETTE palette);

// Stack Routines ///////////////////////////////////////////////////////////
void  GV_StackInit(PSTACK stack, UINT size);

void  GV_StackFree(PSTACK stack);

void  GV_StatcResize(PSTACK stack, UINT size);

UINT  GV_StackSize(PSTACK stack);

UINT  GV_StackIndex(PSTACK stack);

PVOID GV_StackFirst(PSTACK stack);

PVOID GV_StackGet(PSTACK stack, UINT index);

void  GV_StackPut(PSTACK stack, UINT index, PVOID element);

void  GV_StackPush(PSTACK stack, PVOID element);

PVOID GV_StackPop(PSTACK stack);

void  GV_StackClear(PSTACK stack);

// COLLISION DETECTION ROUTINES /////////////////////////////////////////////
//BOOL GV_Overlap(float ax, float ay, int aw, int ah, float bx, float by,
//  int bw, int bh, float factor);

BOOL GV_Overlap(float ax, float ay, float aw, float ah, float bx, float by,
  float bw, float bh, float factor);

BOOL GV_OverlapTopLeft(float ax1, float ay1, int aw, int ad, float bx1,
  float by1, int bw, int bd);

// TASK LIST ROUTINES ///////////////////////////////////////////////////////
void GV_TaskListInit(PTASKLIST tasklist);

void GV_TaskListClear(PTASKLIST tasklist);

void GV_TaskListAppend(PTASKLIST tasklist, PTASK atask);

void GV_TaskListInsert(PTASKLIST tasklist, PTASK atask);

void GV_TaskListInsertAfter(PTASKLIST, PTASK atask, PTASK item);

void GV_TaskListInsertBefore(PTASKLIST, PTASK atask, PTASK item);

void GV_TaskListRemove(PTASK atask);

void GV_TaskListProcess(PTASKLIST tasklist);

BOOL GV_TaskListCheckDistance(PTASKLIST tasklist, PTASK task, int dist);

void GV_TaskListCheckCollide(PTASKLIST tasklist, PTASK task, float factor);

void GV_TaskListSendMsg(PTASKLIST tasklist, int id, PUCHAR data);

// LIBRARY ROUTINES /////////////////////////////////////////////////////////
BOOL GV_LibCreate(PLIBRARY lib, const PCHAR filename);

BOOL GV_LibOpen(PLIBRARY lib, const PCHAR filename);

BOOL GV_LibClose(PLIBRARY lib);

BOOL GV_LibAddFile(PLIBRARY lib, const PCHAR filename);

BOOL GV_LibAddFileIndex(PLIBRARY lib, const PCHAR filename, int index);

PFILE GV_LibFindFile(PLIBRARY lib, const PCHAR filename);

long GV_LibFilePos(PLIBRARY lib, const PCHAR filename);

long GV_LibFileSize(PLIBRARY lib, const PCHAR filename);

void GV_LibReadNext(PLIBRARY lib, long size, PVOID data);

BOOL GV_LibReadFile(PLIBRARY lib, const PCHAR filename, PVOID data);


// FADE PALETTE ROUTINES ////////////////////////////////////////////////////
void GV_FadePalOutStart(PFADEPALETTE fadepalette, PPALETTE pal, int level,
  int fade_delay);

void GV_FadePalInStart(PFADEPALETTE fadepalette, PPALETTE palette, int level,
  int fade_delay);

BOOL GV_FadePalOut(PFADEPALETTE fadepalette);

BOOL GV_FadePalIn(PFADEPALETTE fadepalette);

// STRING ROUTINES //////////////////////////////////////////////////////////
char *GV_StripFileName(char *path, char *ext);

// CLIPPING ROUTINES ////////////////////////////////////////////////////////
int GV_ClipLine(int *x1,int *y1,int *x2, int *y2, int clip_x1, int clip_y1,
  int clip_x2, int clip_y2);

BOOL GV_ClipPoint(int *x1, int *y1, int *x2, int *y2, int clip_x1,
  int clip_y1, int clip_x2, int clip_y2);

// LINE ROUTINES ////////////////////////////////////////////////////////////
void GV_Line(int x1, int y1, int x2, int y2, int color, PUCHAR page);
void GV_LineClip(int x1, int y1, int x2, int y2, int color, PUCHAR page,
  int clip_x1, int clip_y1, int clip_x2, int clip_y2);

// POLYGON ROUTINES /////////////////////////////////////////////////////////
void GV_PolyDraw(PPOLYGON polygon, int x, int y, PUCHAR page);

void GV_PolyDrawClip(PPOLYGON polygon, int x, int y, PUCHAR page, int x1,
  int y1, int x2, int y2);

void GV_PolyScale(PPOLYGON polygon, float scale);

void GV_PolyRotate(PPOLYGON polygon, int angle);

/////////////////////////////////////////////////////////////////////////////
// PRE-BUILDIT TASK LIBRARY                                                //
/////////////////////////////////////////////////////////////////////////////

// FADE TASK ////////////////////////////////////////////////////////////////
void Fade_Init(PPALETTE pal, int type, int level, int fade_delay,
  PTASKLIST tasklist);

void Fade_Process(PTASK task);

void Fade_Done(PTASK task);

#endif
