/////////////////////////////////////////////////////////////////////////////
// VC.H                                                                    //
//                                                                         //
// Rex Blade(tm) Virtual Computer                                          //
// Copyright (c) 1996 Xtreme Games                                         //
// All rights reserved.                                                    //
/////////////////////////////////////////////////////////////////////////////

// DEFINES //////////////////////////////////////////////////////////////////


// Sound IDs
#define FIRE1_SND       0 // laser
#define FIRE2_SND       1 // bullete
#define FIRE3_SND       2 // fire ball
#define HIT1_SND        3 // shields
#define HIT2_SND        4 // shields
#define EXPLODE1_SND    5 // expli
#define EXPLODE2_SND    6
#define GOAL1_SND       7
#define MENUSEL_SND     8
#define ENCODING_SND    9
#define DIGITIZING_SND 10
#define TELEPORT_SND   11
#define PICKUP_SND     12
#define SOUND_MAX      13

// Midi IDs
#define METEOR_MUZ   0
#define QUEST_MUZ    1
#define MIDI_MAX     2

// RPC
#define REX_RPC_COMM_TELEPORT_RESET 0

#define REX_RPC_COM_TELEPORT_INNER   1
#define REX_RPC_COM_TELEPORT_LEVEL   2

#define REX_RPC_COMM_UPDATE_PLASMA  10
#define REX_RPC_COMM_UPDATE_APRS    11
#define REX_RPC_COMM_UPDATE_NANITE  12
#define REX_RPC_COMM_UPDATE_ARMGEL  13
#define REX_RPC_COMM_UPDATE_POWER   14

#define REX_RPC_RESULT_ERROR        0
#define REX_RPC_RESULT_YES          1
#define REX_RPC_RESULT_NO           2


// Teleport
#define REX_COMM_TELEPORT_INNER     1
#define REX_COMM_TELEPORT_LEVEL     2

// STRUCTURES ///////////////////////////////////////////////////////////////
// Fli
struct  fli
	{
	unsigned short int     frames;
	unsigned short int     width;
	unsigned short int     height;
	unsigned short int     speed;
	unsigned short int     current;
	unsigned long          crntoff;
	unsigned short int     handle;
	};


// Virtual Computer Interface
typedef struct rex_vc_context_typ
{
  int  command;
  int  iparms[8];
  char world_name[80];
  char level_name[80];
  char log_file[80];
  char qa_file[80];
  char pass_file[80];
  char program_file[80];
  char splash_file[80];
  char com_file_pcx[80];
  void *extra;
} rex_vc_context_obj, *rex_vc_context_obj_ptr;

// Remote Procedure Control Interface
typedef struct rex_rpc_typ
{
  int   command;
  int   iparms[8];
  float fparms[8];
  char  text[256];
  void  *extra;
} rex_rpc_obj, *rex_rpc_obj_ptr;

// GLOBALS //////////////////////////////////////////////////////////////////

// Sound & midi
extern char *sound_files[SOUND_MAX];
extern char *midi_files[MIDI_MAX];

// Double buffer
extern unsigned char *rex_vc_dblbuf;

// Digital
extern int (*Rex_VC_Play_Dig_File)(char *filename, int volume, int rate);
extern int (*Rex_VC_Play_Dig)(int sound_name, int volume, int rate);
extern int (*Rex_VC_Stop_Dig)(int sound_id);
extern int (*Rex_VC_Status_Dig)(int sound_id);

// Midi
extern int (*Rex_VC_Play_Mid)(int midi_name, int volume);
extern int (*Rex_VC_Stop_Mid)(int midi_id);
extern int (*Rex_VC_Status_Mid)(int midi_id);

// Joystick
extern int (*Rex_VC_Joystick)(int *dx, int *dy, int *buttons);

// Remote Procedure Control Interface
extern int (*Rex_VC_RPC_Interface)(rex_rpc_obj_ptr request);

// Virtual Computer Interface
extern int (*Rex_VC_Run)(rex_vc_context_obj_ptr info);

// PROTOTYPES ///////////////////////////////////////////////////////////////

// fli
extern unsigned char * fli_pal;
extern int fli_use_pal;
enum fli_source { FLI_RAM, FLI_DISK, FLI_AUTO };
void play_fli(char *name, int wait_key);
fli * load_fli(char *filename,fli_source playtype);
short int play_frame(fli *fliptr,char *dest,short int sizex);
void close_fli(fli *fliptr);

// retrace
void GV_WaitVR();

// VC
void VC_GetInput();
void VC_TaskListsInit();
void VC_TaskListsClearAll();
void VC_TaskListsClear();
void VC_TaskListsProcess();

// Games
void Run_Meteor();
void Run_Quest();
void Run_Astro();
void Run_OutPost9();
void Run_Rexpp();
