/////////////////////////////////////////////////////////////////////////////
// VCRUN.CPP                                                               //
//                                                                         //
// Rex Blade(tm) Virtual Computer                                          //
// Copyright (c) 1996 Xtreme Games                                         //
// All rights reserved.                                                    //
/////////////////////////////////////////////////////////////////////////////

// INCLUDES /////////////////////////////////////////////////////////////////
#include "gv.h"
#include "vc.h"

// DEFINES //////////////////////////////////////////////////////////////////

// STRUCTURES ///////////////////////////////////////////////////////////////

// GLOBALS //////////////////////////////////////////////////////////////////
rex_vc_context_obj info;

// PROTOTYPES ///////////////////////////////////////////////////////////////


// SOUND & MIDI ROUTINES
int PlaySndFile(char *filename, int volume, int rate)
{
  return(0);
}

int PlaySnd(int sound_name, int volume, int rate)
{
  return(0);
}

int PlayMid(int midi_name, int volume)
{
  return(0);
}

int StopMid(int midi_id)
{
  return(0);
}

// RPC
int RPC(rex_rpc_obj_ptr request)
{
  int result;

  switch (request->command)
  {
    case REX_RPC_COM_TELEPORT_INNER: result = REX_RPC_RESULT_YES; break;
    case REX_RPC_COM_TELEPORT_LEVEL: result = REX_RPC_RESULT_YES; break;
  }

  return result;
}

// MAIN /////////////////////////////////////////////////////////////////////
void main()
{
  // init double buffer
  rex_vc_dblbuf = GV_PageNew();

  // init sound & midi interface
  //Rex_VC_Play_Dig = &PlaySnd;
  //Rex_VC_Play_Mid = &PlayMid;
  //Rex_VC_Stop_Mid = &StopMid;

  // RPC
  Rex_VC_RPC_Interface = RPC;

  // init vc context
  strcpy((char *)&info.world_name, "");
  strcpy((char *)&info.level_name, "");
  strcpy((char *)&info.qa_file, "world1.qa");
  strcpy((char *)&info.log_file, "world1.log");
  strcpy((char *)&info.pass_file, "world1.pwd");
  strcpy((char *)&info.program_file, "world1.prg");
  strcpy((char *)&info.splash_file, "world1.spl");
  strcpy((char *)&info.com_file_pcx, "world1.mon");
  info.command = REX_COMM_TELEPORT_LEVEL;

  // init graph mode
  GV_ModeSet(0x013);

  // run virtual computer
  Rex_VC_Run(&info);

  // free double buffer
  GV_PageFree(rex_vc_dblbuf);

  // init text mode
  GV_ModeSet(0x03);
}

